//********************************************************************************
//*
//*  C++ finite element method for heat equation
//*  James sandham
//*  15 April 2015
//*
//********************************************************************************

//********************************************************************************
//
// HeatFE is free software; you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License (as published by the Free
// Software Foundation) version 2.1 dated February 1999.
//
//********************************************************************************

#include<iostream>
#include<GL/glut.h>
#include"Display.h"


GLfloat x_angle = 0.0;
GLfloat y_angle = 0.0;
GLfloat scale = 1.0;
GLfloat x_position = 0.0;
GLfloat y_position = 0.0;
GLfloat z_position = 0.0;


//----------------------------------------------------------------------------
// Main opengl loop
//----------------------------------------------------------------------------
void opengl_main(int argc, char** argv)
{
  //initialize window
  glutInit(&argc,argv);
  glutInitDisplayMode(GLUT_DOUBLE);
  glutInitWindowPosition(100,100);
  glutInitWindowSize(640,480);
  glutCreateWindow("finite element mesh");

  //keyboard and mouse functions
  glutKeyboardFunc(keyboard);
  glutSpecialFunc(keyboard_arrows); 
  glutMouseFunc(mouse);

  //render function
  glutDisplayFunc(render_mesh);

  //main loop
  glutMainLoop();
}



//----------------------------------------------------------------------------
// render the mesh
//----------------------------------------------------------------------------
void render_mesh()
{
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  glLoadIdentity();
  gluLookAt(0.0,0.0,0.0,0.0,0.0,-1.0,0.0,1.0,0.0);
  glEnable(GL_DEPTH_TEST);
 
  //translations, rotations, and scalings
  glTranslatef(x_position,y_position,z_position);
  glRotatef(x_angle,0,1,0);
  glRotatef(y_angle,1,0,0);
  glScalef(scale,scale,scale);

  //draw mesh
  glNewList(1,GL_COMPILE);
    for(int i=0;i<*numOfElements;i++){
      glBegin(GL_LINE_LOOP);
      for(int j=0;j<*numOfPointsElements;j++){
        glVertex3f(x_pts[connArray[i][j+1]],
                   y_pts[connArray[i][j+1]],
                   z_pts[connArray[i][j+1]]);
      }
      glEnd();
    }
    //glColor3f(0.0,0.2,0.5);
    //glBegin(GL_LINE_LOOP);
    //  glVertex3f(0.0,0.0,0.0);
    //  glVertex3f(0,0.5,0.0);
    //  glVertex3f(0.4,-0.1,0.0);
    //glEnd();
    //glColor3f(0.7,0.2,0.5);
    //glBegin(GL_LINE_LOOP);
    //  glVertex3f(0.8,0.5,0.0);
    //  glVertex3f(0,0.5,0.0);
    //  glVertex3f(0.4,-0.1,0.0);
    //glEnd();
  glEndList();
  glCallList(1);

  //glutWireTeapot(0.25);

  glutSwapBuffers();
}



//----------------------------------------------------------------------------
// render the mesh
//----------------------------------------------------------------------------
void render_solution()
{

}



void keyboard(unsigned char key, int x, int y)
{
  if(key==27){exit(0);} 
  if(key=='z'){scale += 0.1; glutPostRedisplay();}
  if(key=='x'){scale -= 0.1; glutPostRedisplay();}
}



void keyboard_arrows(int key, int x, int y)
{
  if(key==GLUT_KEY_LEFT){x_angle -= 1; glutPostRedisplay();}
  if(key==GLUT_KEY_RIGHT){x_angle += 1; glutPostRedisplay();}
  if(key==GLUT_KEY_UP){y_angle += 1; glutPostRedisplay();}
  if(key==GLUT_KEY_DOWN){y_angle -= 1; glutPostRedisplay();} 
}



void mouse(int button, int state, int x, int y)
{

}
